<?php
/**
 * The template to display Admin notices
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.64
 */

$corbesier_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$corbesier_skins_args = get_query_var( 'corbesier_skins_notice_args' );
?>
<div class="corbesier_admin_notice corbesier_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$corbesier_theme_img = corbesier_get_file_url( 'screenshot.jpg' );
	if ( '' != $corbesier_theme_img ) {
		?>
		<div class="corbesier_notice_image"><img src="<?php echo esc_url( $corbesier_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'corbesier' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="corbesier_notice_title">
		<?php esc_html_e( 'New skins available', 'corbesier' ); ?>
	</h3>
	<?php

	// Description
	$corbesier_total      = $corbesier_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$corbesier_skins_msg  = $corbesier_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $corbesier_total, 'corbesier' ), $corbesier_total ) . '</strong>'
							: '';
	$corbesier_total      = $corbesier_skins_args['free'];
	$corbesier_skins_msg .= $corbesier_total > 0
							? ( ! empty( $corbesier_skins_msg ) ? ' ' . esc_html__( 'and', 'corbesier' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $corbesier_total, 'corbesier' ), $corbesier_total ) . '</strong>'
							: '';
	$corbesier_total      = $corbesier_skins_args['pay'];
	$corbesier_skins_msg .= $corbesier_skins_args['pay'] > 0
							? ( ! empty( $corbesier_skins_msg ) ? ' ' . esc_html__( 'and', 'corbesier' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $corbesier_total, 'corbesier' ), $corbesier_total ) . '</strong>'
							: '';
	?>
	<div class="corbesier_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'corbesier' ), $corbesier_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="corbesier_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $corbesier_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'corbesier' );
			?>
		</a>
	</div>
</div>
