<?php
/**
 * The template to display the widgets area in the header
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

// Header sidebar
$corbesier_header_name    = corbesier_get_theme_option( 'header_widgets' );
$corbesier_header_present = ! corbesier_is_off( $corbesier_header_name ) && is_active_sidebar( $corbesier_header_name );
if ( $corbesier_header_present ) {
	corbesier_storage_set( 'current_sidebar', 'header' );
	$corbesier_header_wide = corbesier_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $corbesier_header_name ) ) {
		dynamic_sidebar( $corbesier_header_name );
	}
	$corbesier_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $corbesier_widgets_output ) ) {
		$corbesier_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $corbesier_widgets_output );
		$corbesier_need_columns   = strpos( $corbesier_widgets_output, 'columns_wrap' ) === false;
		if ( $corbesier_need_columns ) {
			$corbesier_columns = max( 0, (int) corbesier_get_theme_option( 'header_columns' ) );
			if ( 0 == $corbesier_columns ) {
				$corbesier_columns = min( 6, max( 1, corbesier_tags_count( $corbesier_widgets_output, 'aside' ) ) );
			}
			if ( $corbesier_columns > 1 ) {
				$corbesier_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $corbesier_columns ) . ' widget', $corbesier_widgets_output );
			} else {
				$corbesier_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $corbesier_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'corbesier_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $corbesier_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $corbesier_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'corbesier_action_before_sidebar', 'header' );
				corbesier_show_layout( $corbesier_widgets_output );
				do_action( 'corbesier_action_after_sidebar', 'header' );
				if ( $corbesier_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $corbesier_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'corbesier_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
