<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package CORBESIER
 * @since CORBESIER 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$corbesier_copyright_scheme = corbesier_get_theme_option( 'copyright_scheme' );
if ( ! empty( $corbesier_copyright_scheme ) && ! corbesier_is_inherit( $corbesier_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $corbesier_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$corbesier_copyright = corbesier_get_theme_option( 'copyright' );
			if ( ! empty( $corbesier_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$corbesier_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $corbesier_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$corbesier_copyright = corbesier_prepare_macros( $corbesier_copyright );
				// Display copyright
				echo wp_kses( nl2br( $corbesier_copyright ), 'corbesier_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
