<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_template_args = get_query_var( 'corbesier_template_args' );
if ( is_array( $corbesier_template_args ) ) {
	$corbesier_columns    = empty( $corbesier_template_args['columns'] ) ? 2 : max( 1, $corbesier_template_args['columns'] );
	$corbesier_blog_style = array( $corbesier_template_args['type'], $corbesier_columns );
    $corbesier_columns_class = corbesier_get_column_class( 1, $corbesier_columns, ! empty( $corbesier_template_args['columns_tablet']) ? $corbesier_template_args['columns_tablet'] : '', ! empty($corbesier_template_args['columns_mobile']) ? $corbesier_template_args['columns_mobile'] : '' );
} else {
	$corbesier_blog_style = explode( '_', corbesier_get_theme_option( 'blog_style' ) );
	$corbesier_columns    = empty( $corbesier_blog_style[1] ) ? 2 : max( 1, $corbesier_blog_style[1] );
    $corbesier_columns_class = corbesier_get_column_class( 1, $corbesier_columns );
}

$corbesier_post_format = get_post_format();
$corbesier_post_format = empty( $corbesier_post_format ) ? 'standard' : str_replace( 'post-format-', '', $corbesier_post_format );

?><div class="
<?php
if ( ! empty( $corbesier_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( corbesier_is_blog_style_use_masonry( $corbesier_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $corbesier_columns ) : esc_attr( $corbesier_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $corbesier_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $corbesier_columns )
		. ( 'portfolio' != $corbesier_blog_style[0] ? ' ' . esc_attr( $corbesier_blog_style[0] )  . '_' . esc_attr( $corbesier_columns ) : '' )
	);
	corbesier_add_blog_animation( $corbesier_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$corbesier_hover   = ! empty( $corbesier_template_args['hover'] ) && ! corbesier_is_inherit( $corbesier_template_args['hover'] )
								? $corbesier_template_args['hover']
								: corbesier_get_theme_option( 'image_hover' );

	if ( 'dots' == $corbesier_hover ) {
		$corbesier_post_link = empty( $corbesier_template_args['no_links'] )
								? ( ! empty( $corbesier_template_args['link'] )
									? $corbesier_template_args['link']
									: get_permalink()
									)
								: '';
		$corbesier_target    = ! empty( $corbesier_post_link ) && false === strpos( $corbesier_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$corbesier_components = ! empty( $corbesier_template_args['meta_parts'] )
							? ( is_array( $corbesier_template_args['meta_parts'] )
								? $corbesier_template_args['meta_parts']
								: explode( ',', $corbesier_template_args['meta_parts'] )
								)
							: corbesier_array_get_keys_by_value( corbesier_get_theme_option( 'meta_parts' ) );

	// Featured image
	corbesier_show_post_featured( apply_filters( 'corbesier_filter_args_featured',
        array(
			'hover'         => $corbesier_hover,
			'no_links'      => ! empty( $corbesier_template_args['no_links'] ),
			'thumb_size'    => ! empty( $corbesier_template_args['thumb_size'] )
								? $corbesier_template_args['thumb_size']
								: corbesier_get_thumb_size(
									corbesier_is_blog_style_use_masonry( $corbesier_blog_style[0] )
										? (	strpos( corbesier_get_theme_option( 'body_style' ), 'full' ) !== false || $corbesier_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( corbesier_get_theme_option( 'body_style' ), 'full' ) !== false || $corbesier_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => corbesier_is_blog_style_use_masonry( $corbesier_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $corbesier_components,
			'class'         => 'dots' == $corbesier_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $corbesier_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $corbesier_post_link )
												? '<a href="' . esc_url( $corbesier_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $corbesier_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $corbesier_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $corbesier_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!