<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_template_args = get_query_var( 'corbesier_template_args' );
$corbesier_columns = 1;
if ( is_array( $corbesier_template_args ) ) {
	$corbesier_columns    = empty( $corbesier_template_args['columns'] ) ? 1 : max( 1, $corbesier_template_args['columns'] );
	$corbesier_blog_style = array( $corbesier_template_args['type'], $corbesier_columns );
	if ( ! empty( $corbesier_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $corbesier_columns > 1 ) {
	    $corbesier_columns_class = corbesier_get_column_class( 1, $corbesier_columns, ! empty( $corbesier_template_args['columns_tablet']) ? $corbesier_template_args['columns_tablet'] : '', ! empty($corbesier_template_args['columns_mobile']) ? $corbesier_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $corbesier_columns_class ); ?>">
		<?php
	}
}
$corbesier_expanded    = ! corbesier_sidebar_present() && corbesier_get_theme_option( 'expand_content' ) == 'expand';
$corbesier_post_format = get_post_format();
$corbesier_post_format = empty( $corbesier_post_format ) ? 'standard' : str_replace( 'post-format-', '', $corbesier_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $corbesier_post_format ) );
	corbesier_add_blog_animation( $corbesier_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$corbesier_hover      = ! empty( $corbesier_template_args['hover'] ) && ! corbesier_is_inherit( $corbesier_template_args['hover'] )
							? $corbesier_template_args['hover']
							: corbesier_get_theme_option( 'image_hover' );
	$corbesier_components = ! empty( $corbesier_template_args['meta_parts'] )
							? ( is_array( $corbesier_template_args['meta_parts'] )
								? $corbesier_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $corbesier_template_args['meta_parts'] ) )
								)
							: corbesier_array_get_keys_by_value( corbesier_get_theme_option( 'meta_parts' ) );
	corbesier_show_post_featured( apply_filters( 'corbesier_filter_args_featured',
		array(
			'no_links'   => ! empty( $corbesier_template_args['no_links'] ),
			'hover'      => $corbesier_hover,
			'meta_parts' => $corbesier_components,
			'thumb_size' => ! empty( $corbesier_template_args['thumb_size'] )
							? $corbesier_template_args['thumb_size']
							: corbesier_get_thumb_size( strpos( corbesier_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $corbesier_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$corbesier_template_args
	) );

	// Title and post meta
	$corbesier_show_title = get_the_title() != '';
	$corbesier_show_meta  = count( $corbesier_components ) > 0 && ! in_array( $corbesier_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $corbesier_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'corbesier_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'corbesier_action_before_post_title' );
				if ( empty( $corbesier_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'corbesier_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'corbesier_filter_show_blog_excerpt', empty( $corbesier_template_args['hide_excerpt'] ) && corbesier_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'corbesier_filter_show_blog_meta', $corbesier_show_meta, $corbesier_components, 'excerpt' ) ) {
				if ( count( $corbesier_components ) > 0 ) {
					do_action( 'corbesier_action_before_post_meta' );
					corbesier_show_post_meta(
						apply_filters(
							'corbesier_filter_post_meta_args', array(
								'components' => join( ',', $corbesier_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'corbesier_action_after_post_meta' );
				}
			}

			if ( corbesier_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'corbesier_action_before_full_post_content' );
					the_content( '' );
					do_action( 'corbesier_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'corbesier' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'corbesier' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				corbesier_show_post_content( $corbesier_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'corbesier_filter_show_blog_readmore',  ! isset( $corbesier_template_args['more_button'] ) || ! empty( $corbesier_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $corbesier_template_args['no_links'] ) ) {
					do_action( 'corbesier_action_before_post_readmore' );
					if ( corbesier_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						corbesier_show_post_more_link( $corbesier_template_args, '<p>', '</p>' );
					} else {
						corbesier_show_post_comments_link( $corbesier_template_args, '<p>', '</p>' );
					}
					do_action( 'corbesier_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $corbesier_template_args ) ) {
	if ( ! empty( $corbesier_template_args['slider'] ) || $corbesier_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
