<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

$corbesier_template_args = get_query_var( 'corbesier_template_args' );

if ( is_array( $corbesier_template_args ) ) {
	$corbesier_columns    = empty( $corbesier_template_args['columns'] ) ? 2 : max( 1, $corbesier_template_args['columns'] );
	$corbesier_blog_style = array( $corbesier_template_args['type'], $corbesier_columns );
    $corbesier_columns_class = corbesier_get_column_class( 1, $corbesier_columns, ! empty( $corbesier_template_args['columns_tablet']) ? $corbesier_template_args['columns_tablet'] : '', ! empty($corbesier_template_args['columns_mobile']) ? $corbesier_template_args['columns_mobile'] : '' );
} else {
	$corbesier_blog_style = explode( '_', corbesier_get_theme_option( 'blog_style' ) );
	$corbesier_columns    = empty( $corbesier_blog_style[1] ) ? 2 : max( 1, $corbesier_blog_style[1] );
    $corbesier_columns_class = corbesier_get_column_class( 1, $corbesier_columns );
}
$corbesier_expanded   = ! corbesier_sidebar_present() && corbesier_get_theme_option( 'expand_content' ) == 'expand';

$corbesier_post_format = get_post_format();
$corbesier_post_format = empty( $corbesier_post_format ) ? 'standard' : str_replace( 'post-format-', '', $corbesier_post_format );

?><div class="<?php
	if ( ! empty( $corbesier_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( corbesier_is_blog_style_use_masonry( $corbesier_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $corbesier_columns ) : esc_attr( $corbesier_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $corbesier_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $corbesier_columns )
				. ' post_layout_' . esc_attr( $corbesier_blog_style[0] )
				. ' post_layout_' . esc_attr( $corbesier_blog_style[0] ) . '_' . esc_attr( $corbesier_columns )
	);
	corbesier_add_blog_animation( $corbesier_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$corbesier_hover      = ! empty( $corbesier_template_args['hover'] ) && ! corbesier_is_inherit( $corbesier_template_args['hover'] )
							? $corbesier_template_args['hover']
							: corbesier_get_theme_option( 'image_hover' );

	$corbesier_components = ! empty( $corbesier_template_args['meta_parts'] )
							? ( is_array( $corbesier_template_args['meta_parts'] )
								? $corbesier_template_args['meta_parts']
								: explode( ',', $corbesier_template_args['meta_parts'] )
								)
							: corbesier_array_get_keys_by_value( corbesier_get_theme_option( 'meta_parts' ) );

	corbesier_show_post_featured( apply_filters( 'corbesier_filter_args_featured',
		array(
			'thumb_size' => ! empty( $corbesier_template_args['thumb_size'] )
				? $corbesier_template_args['thumb_size']
				: corbesier_get_thumb_size(
				'classic' == $corbesier_blog_style[0]
						? ( strpos( corbesier_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $corbesier_columns > 2 ? 'big' : 'huge' )
								: ( $corbesier_columns > 2
									? ( $corbesier_expanded ? 'square' : 'square' )
									: ($corbesier_columns > 1 ? 'square' : ( $corbesier_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( corbesier_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $corbesier_columns > 2 ? 'masonry-big' : 'full' )
								: ($corbesier_columns === 1 ? ( $corbesier_expanded ? 'huge' : 'big' ) : ( $corbesier_columns <= 2 && $corbesier_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $corbesier_hover,
			'meta_parts' => $corbesier_components,
			'no_links'   => ! empty( $corbesier_template_args['no_links'] ),
        ),
        'content-classic',
        $corbesier_template_args
    ) );

	// Title and post meta
	$corbesier_show_title = get_the_title() != '';
	$corbesier_show_meta  = count( $corbesier_components ) > 0 && ! in_array( $corbesier_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $corbesier_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'corbesier_filter_show_blog_meta', $corbesier_show_meta, $corbesier_components, 'classic' ) ) {
				if ( count( $corbesier_components ) > 0 ) {
					do_action( 'corbesier_action_before_post_meta' );
					corbesier_show_post_meta(
						apply_filters(
							'corbesier_filter_post_meta_args', array(
							'components' => join( ',', $corbesier_components ),
							'seo'        => false,
							'echo'       => true,
						), $corbesier_blog_style[0], $corbesier_columns
						)
					);
					do_action( 'corbesier_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'corbesier_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'corbesier_action_before_post_title' );
				if ( empty( $corbesier_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'corbesier_action_after_post_title' );
			}

			if( !in_array( $corbesier_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'corbesier_filter_show_blog_readmore', ! $corbesier_show_title || ! empty( $corbesier_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $corbesier_template_args['no_links'] ) ) {
						do_action( 'corbesier_action_before_post_readmore' );
						corbesier_show_post_more_link( $corbesier_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'corbesier_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $corbesier_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('corbesier_filter_show_blog_excerpt', empty($corbesier_template_args['hide_excerpt']) && corbesier_get_theme_option('excerpt_length') > 0, 'classic')) {
			corbesier_show_post_content($corbesier_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $corbesier_template_args['more_button'] )) {
			if ( empty( $corbesier_template_args['no_links'] ) ) {
				do_action( 'corbesier_action_before_post_readmore' );
				corbesier_show_post_more_link( $corbesier_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'corbesier_action_after_post_readmore' );
			}
		}
		$corbesier_content = ob_get_contents();
		ob_end_clean();
		corbesier_show_layout($corbesier_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
