<?php
/**
 * The template to display single post
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

// Full post loading
$full_post_loading          = corbesier_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = corbesier_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = corbesier_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$corbesier_related_position   = corbesier_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$corbesier_posts_navigation   = corbesier_get_theme_option( 'posts_navigation' );
$corbesier_prev_post          = false;
$corbesier_prev_post_same_cat = corbesier_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( corbesier_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	corbesier_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'corbesier_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $corbesier_posts_navigation ) {
		$corbesier_prev_post = get_previous_post( $corbesier_prev_post_same_cat );  // Get post from same category
		if ( ! $corbesier_prev_post && $corbesier_prev_post_same_cat ) {
			$corbesier_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $corbesier_prev_post ) {
			$corbesier_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $corbesier_prev_post ) ) {
		corbesier_sc_layouts_showed( 'featured', false );
		corbesier_sc_layouts_showed( 'title', false );
		corbesier_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $corbesier_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'corbesier_filter_get_template_part', 'templates/content', 'single-' . corbesier_get_theme_option( 'single_style' ) ), 'single-' . corbesier_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $corbesier_related_position, 'inside' ) === 0 ) {
		$corbesier_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'corbesier_action_related_posts' );
		$corbesier_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $corbesier_related_content ) ) {
			$corbesier_related_position_inside = max( 0, min( 9, corbesier_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $corbesier_related_position_inside ) {
				$corbesier_related_position_inside = mt_rand( 1, 9 );
			}

			$corbesier_p_number         = 0;
			$corbesier_related_inserted = false;
			$corbesier_in_block         = false;
			$corbesier_content_start    = strpos( $corbesier_content, '<div class="post_content' );
			$corbesier_content_end      = strrpos( $corbesier_content, '</div>' );

			for ( $i = max( 0, $corbesier_content_start ); $i < min( strlen( $corbesier_content ) - 3, $corbesier_content_end ); $i++ ) {
				if ( $corbesier_content[ $i ] != '<' ) {
					continue;
				}
				if ( $corbesier_in_block ) {
					if ( strtolower( substr( $corbesier_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$corbesier_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $corbesier_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $corbesier_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$corbesier_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $corbesier_content[ $i + 1 ] && in_array( $corbesier_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$corbesier_p_number++;
					if ( $corbesier_related_position_inside == $corbesier_p_number ) {
						$corbesier_related_inserted = true;
						$corbesier_content = ( $i > 0 ? substr( $corbesier_content, 0, $i ) : '' )
											. $corbesier_related_content
											. substr( $corbesier_content, $i );
					}
				}
			}
			if ( ! $corbesier_related_inserted ) {
				if ( $corbesier_content_end > 0 ) {
					$corbesier_content = substr( $corbesier_content, 0, $corbesier_content_end ) . $corbesier_related_content . substr( $corbesier_content, $corbesier_content_end );
				} else {
					$corbesier_content .= $corbesier_related_content;
				}
			}
		}

		corbesier_show_layout( $corbesier_content );
	}

	// Comments
	do_action( 'corbesier_action_before_comments' );
	comments_template();
	do_action( 'corbesier_action_after_comments' );

	// Related posts
	if ( 'below_content' == $corbesier_related_position
		&& ( 'scroll' != $corbesier_posts_navigation || corbesier_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || corbesier_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'corbesier_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $corbesier_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $corbesier_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $corbesier_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $corbesier_prev_post ) ); ?>"
			<?php do_action( 'corbesier_action_nav_links_single_scroll_data', $corbesier_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
