<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package CORBESIER
 * @since CORBESIER 1.0
 */

if ( corbesier_sidebar_present() ) {
	
	$corbesier_sidebar_type = corbesier_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $corbesier_sidebar_type && ! corbesier_is_layouts_available() ) {
		$corbesier_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $corbesier_sidebar_type ) {
		// Default sidebar with widgets
		$corbesier_sidebar_name = corbesier_get_theme_option( 'sidebar_widgets' );
		corbesier_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $corbesier_sidebar_name ) ) {
			dynamic_sidebar( $corbesier_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$corbesier_sidebar_id = corbesier_get_custom_sidebar_id();
		do_action( 'corbesier_action_show_layout', $corbesier_sidebar_id );
	}
	$corbesier_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $corbesier_out ) ) {
		$corbesier_sidebar_position    = corbesier_get_theme_option( 'sidebar_position' );
		$corbesier_sidebar_position_ss = corbesier_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $corbesier_sidebar_position );
			echo ' sidebar_' . esc_attr( $corbesier_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $corbesier_sidebar_type );

			$corbesier_sidebar_scheme = apply_filters( 'corbesier_filter_sidebar_scheme', corbesier_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $corbesier_sidebar_scheme ) && ! corbesier_is_inherit( $corbesier_sidebar_scheme ) && 'custom' != $corbesier_sidebar_type ) {
				echo ' scheme_' . esc_attr( $corbesier_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="corbesier_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'corbesier_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $corbesier_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$corbesier_title = apply_filters( 'corbesier_filter_sidebar_control_title', 'float' == $corbesier_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'corbesier' ) : '' );
				$corbesier_text  = apply_filters( 'corbesier_filter_sidebar_control_text', 'above' == $corbesier_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'corbesier' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $corbesier_title ); ?>"><?php echo esc_html( $corbesier_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'corbesier_action_before_sidebar', 'sidebar' );
				corbesier_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $corbesier_out ) );
				do_action( 'corbesier_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'corbesier_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
