<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'corbesier_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'corbesier_cf7_theme_setup9', 9 );
	function corbesier_cf7_theme_setup9() {
		if ( corbesier_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'corbesier_cf7_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_cf7', 'corbesier_cf7_frontend_scripts', 10, 1 );
			add_filter( 'corbesier_filter_merge_styles', 'corbesier_cf7_merge_styles' );
			add_filter( 'corbesier_filter_merge_scripts', 'corbesier_cf7_merge_scripts' );
		}
		if ( is_admin() ) {
			add_filter( 'corbesier_filter_tgmpa_required_plugins', 'corbesier_cf7_tgmpa_required_plugins' );
			add_filter( 'corbesier_filter_theme_plugins', 'corbesier_cf7_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'corbesier_cf7_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('corbesier_filter_tgmpa_required_plugins',	'corbesier_cf7_tgmpa_required_plugins');
	function corbesier_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( corbesier_storage_isset( 'required_plugins', 'contact-form-7' ) && corbesier_storage_get_array( 'required_plugins', 'contact-form-7', 'install' ) !== false ) {
			// CF7 plugin
			$list[] = array(
				'name'     => corbesier_storage_get_array( 'required_plugins', 'contact-form-7', 'title' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'corbesier_cf7_theme_plugins' ) ) {
	//Handler of the add_filter( 'corbesier_filter_theme_plugins', 'corbesier_cf7_theme_plugins' );
	function corbesier_cf7_theme_plugins( $list = array() ) {
		return corbesier_add_group_and_logo_to_slave( $list, 'contact-form-7', 'contact-form-7-' );
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'corbesier_exists_cf7' ) ) {
	function corbesier_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'corbesier_cf7_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'corbesier_cf7_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_cf7', 'corbesier_cf7_frontend_scripts', 10, 1 );
	function corbesier_cf7_frontend_scripts( $force = false ) {
		static $loaded = false;
		if ( ! $loaded && (
			current_action() == 'wp_enqueue_scripts' && corbesier_need_frontend_scripts( 'cf7' )
			||
			current_action() != 'wp_enqueue_scripts' && $force === true
			)
		) {
			$loaded = true;
			$corbesier_url = corbesier_get_file_url( 'plugins/contact-form-7/contact-form-7.css' );
			if ( '' != $corbesier_url ) {
				wp_enqueue_style( 'corbesier-contact-form-7', $corbesier_url, array(), null );
			}
			$corbesier_url = corbesier_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
			if ( '' != $corbesier_url ) {
				wp_enqueue_script( 'corbesier-contact-form-7', $corbesier_url, array( 'jquery' ), null, true );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'corbesier_cf7_merge_styles' ) ) {
	//Handler of the add_filter('corbesier_filter_merge_styles', 'corbesier_cf7_merge_styles');
	function corbesier_cf7_merge_styles( $list ) {
		$list[ 'plugins/contact-form-7/contact-form-7.css' ] = false;
		return $list;
	}
}

// Merge custom scripts
if ( ! function_exists( 'corbesier_cf7_merge_scripts' ) ) {
	//Handler of the add_filter('corbesier_filter_merge_scripts', 'corbesier_cf7_merge_scripts');
	function corbesier_cf7_merge_scripts( $list ) {
		$list[ 'plugins/contact-form-7/contact-form-7.js' ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( corbesier_exists_cf7() ) {
	$corbesier_fdir = corbesier_get_file_dir( 'plugins/contact-form-7/contact-form-7-style.php' );
	if ( ! empty( $corbesier_fdir ) ) {
		require_once $corbesier_fdir;
	}
}
